#!/bin/bash

if [ "$GINCSVD_SOURCE" == "" ] ; then
  echo "Must specify GINCSVD_SOURCE"
  exit 1
fi

cmake \
  -D CMAKE_BUILD_TYPE=RELEASE \
  -D CMAKE_CXX_COMPILER=/usr/bin/g++ \
  -D CULA_DIR=/usr/local/cula \
  -D CMAKE_CXX_FLAGS="-ansi -pedantic -Wno-long-long" \
  -D CUDA_PROPAGATE_HOST_FLAGS=OFF \
  -D GINCSVD_DEBUG=OFF \
  -D GINCSVD_DOUBLE=ON \
  -D CUDA_NVCC_FLAGS="-arch=sm_30;--compiler-bindir=/usr/bin" \
  $* \
  $GINCSVD_SOURCE
