#include <gincsvd.hpp>
#include <algorithm>
#include <iostream>
#include <iterator>
#include <iomanip>
#include <string>
#include <cstdlib>
#include <cula.hpp>
#include <math.h>
using namespace GINCSVD;
using std::cout; 
using std::endl; 
using std::string;

#ifdef GINCSVD_DOUBLE
typedef double T;
#else
typedef float T;
#endif

int main() {
  float time;
  // 
  cout << "\n"
          "       /------------------------\\\n"
          "       |   G-IncSVD unit tests  |\n" 
          "       \\------------------------/\n\n";
  GINCSVD::init(0);
  // do K > L and L > K
  // need to come up with requirements on size of S... max(K,L), probably
  const int M = 10000;
  const int N =  1000;
  //
  const int LMAX =  15;
  const int KMAX =  15;
  T *U  = new T[M*KMAX],
    *VT = new T[KMAX*N],
    *S  = new T[KMAX];

  cout << "\n";

  cout << std::scientific << std::setprecision(8);

  cout << "Matrix: ones(" << M << "," << N << ")" << endl;
  cout << endl;

  {
    cout << "-----------------------------------------------------------------" << endl;
    const int K = 5,
              L = 15;
    assert(K <= KMAX);
    assert(L <= LMAX);

    cout << "Computing LARGEST " << K << " singular values, with block size " << L << endl;
    time = gincsvd_gen_sync(LARGEST,M,N,K,L,OnesMatrixGenerator<T>(M,L),U,VT,S);
    cout << "Elapsed time: " << time/1e3 << " seconds" << endl;
    cout << "Estimated largest singular values:     ";
    std::copy(S,S+K,std::ostream_iterator<T>(cout,"\t"));
    cout << endl;
    cout << "Expected zeros, except for sigma(1) == " << sqrt(M*N) << endl;

    cout << "\n";

    cout << "Computing SMALLEST " << K << " singular values, with block size " << L << endl;
    time = gincsvd_gen_sync(SMALLEST,M,N,K,L,OnesMatrixGenerator<T>(M,L),U,VT,S);
    cout << "Elapsed time: " << time/1e3 << " seconds" << endl;
    cout << "Estimated smallest singular values: ";
    std::copy(S,S+K,std::ostream_iterator<T>(cout,"\t"));
    cout << endl;
    cout << "Expected zeros." << endl;
    cout << "\n";
  }

  {
    cout << "-----------------------------------------------------------------" << endl;
    const int K = 15,
              L = 5;
    assert(K <= KMAX);
    assert(L <= LMAX);

    cout << "Computing LARGEST " << K << " singular values, with block size " << L << endl;
    time = gincsvd_gen_sync(LARGEST,M,N,K,L,OnesMatrixGenerator<T>(M,L),U,VT,S);
    cout << "Elapsed time: " << time/1e3 << " seconds" << endl;
    cout << "Estimated largest singular values:     ";
    std::copy(S,S+K,std::ostream_iterator<T>(cout,"\t"));
    cout << endl;
    cout << "Expected zeros, except for sigma(1) == " << sqrt(M*N) << endl;

    cout << "\n";

    cout << "Computing SMALLEST " << K << " singular values, with block size " << L << endl;
    time = gincsvd_gen_sync(SMALLEST,M,N,K,L,OnesMatrixGenerator<T>(M,L),U,VT,S);
    cout << "Elapsed time: " << time/1e3 << " seconds" << endl;
    cout << "Estimated smallest singular values: ";
    std::copy(S,S+K,std::ostream_iterator<T>(cout,"\t"));
    cout << endl;
    cout << "Expected zeros." << endl;
    cout << "\n";
  }

  {
    cout << "-----------------------------------------------------------------" << endl;
    const int K = 15,
              L = 15;
    assert(K <= KMAX);
    assert(L <= LMAX);

    cout << "Computing LARGEST " << K << " singular values, with block size " << L << endl;
    time = gincsvd_gen_sync(LARGEST,M,N,K,L,OnesMatrixGenerator<T>(M,L),U,VT,S);
    cout << "Elapsed time: " << time/1e3 << " seconds" << endl;
    cout << "Estimated largest singular values:     ";
    std::copy(S,S+K,std::ostream_iterator<T>(cout,"\t"));
    cout << endl;
    cout << "Expected zeros, except for sigma(1) == " << sqrt(M*N) << endl;

    cout << "\n";

    cout << "Computing SMALLEST " << K << " singular values, with block size " << L << endl;
    time = gincsvd_gen_sync(SMALLEST,M,N,K,L,OnesMatrixGenerator<T>(M,L),U,VT,S);
    cout << "Elapsed time: " << time/1e3 << " seconds" << endl;
    cout << "Estimated smallest singular values: ";
    std::copy(S,S+K,std::ostream_iterator<T>(cout,"\t"));
    cout << endl;
    cout << "Expected zeros." << endl;
    cout << "\n";
  }
  
  return 0;
}
